<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('slow_queries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('sql');
            $table->longText('bindings')->nullable();
            $table->integer('time_ms');
            $table->string('connection', 50)->nullable();
            $table->string('url', 1024)->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->timestamps();

            $table->index(['created_at']);
            $table->index(['time_ms']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('slow_queries');
    }
};

